/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.legacy.blue_skies.registries.SkiesDimensions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DawnModifier
extends Modifier
implements TooltipModifierHook,
MeleeDamageModifierHook,
BreakSpeedModifierHook,
ConditionalStatModifierHook,
ProjectileHitModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.CONDITIONAL_STAT, ModifierHooks.PROJECTILE_HIT});
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getEntity();
        Level world = player.m_20193_();
        if (world.m_46468_() < 24000L && world.m_46468_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) {
            event.setNewSpeed(event.getNewSpeed() + (float)(3 * modifier.getLevel()) * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED));
        }
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        Level world;
        Player player = context.getPlayerAttacker();
        if (player != null && ((world = player.m_9236_()).m_8044_() < 24000L && world.m_8044_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey()))) {
            return damage + (float)(3 * modifier.getLevel()) * tool.getMultiplier((INumericToolStat)ToolStats.ATTACK_DAMAGE);
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_20193_();
        int level = modifier.getLevel();
        if (stat == ToolStats.DRAW_SPEED && (world.m_46468_() < 24000L && world.m_46468_() > 22200L || living.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey()))) {
            return (float)((double)baseValue + 0.1 * (double)level);
        }
        return 0.0f;
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        if (attacker != null && (attacker.m_20193_().m_46468_() < 24000L && attacker.m_20193_().m_46468_() > 22200L || attacker.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) && projectile instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)projectile;
            arrow.m_36781_(arrow.m_36789_() + 0.5 * (double)modifier.getLevel());
        }
        return false;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        Level world;
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && ((world = player.m_20193_()).m_46468_() < 24000L && world.m_46468_() > 22200L || player.f_19853_.m_46472_().equals((Object)SkiesDimensions.everdawnKey())) && (harvest || tool.hasTag(TinkerTags.Items.RANGED)) && tooltipKey == TooltipKey.SHIFT) {
            if (harvest) {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.ATTACK_DAMAGE, (TagKey)TinkerTags.Items.MELEE, (float)(3 * modifier.getLevel()), tooltip);
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.MINING_SPEED, (TagKey)TinkerTags.Items.HARVEST, (float)(3 * modifier.getLevel()), tooltip);
            } else {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.DRAW_SPEED, (TagKey)TinkerTags.Items.RANGED, (float)(0.1f * (float)modifier.getLevel()), tooltip);
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.PROJECTILE_DAMAGE, (TagKey)TinkerTags.Items.RANGED, (float)(0.5f * (float)modifier.getLevel()), tooltip);
            }
        }
    }
}

